#include "include/hardware.h"
#include "include/fll.h"
/**
Delay function.
*/
void delay(unsigned int d) {
   while(d--) {
      nop();
      nop();
   }
}


void SWUART_INIT(void) {

    WDTCTL = WDTCTL_INIT;               //Init watchdog timer

    P1OUT  |= P1OUT_INIT;                //Init output data of port1
    P1SEL  |= P1SEL_INIT;                //Select port or module -function on port1
    P1DIR  |= P1DIR_INIT;                //Init port direction register of port1

    P2OUT  |= P2OUT_INIT;                //Init output data of port2
    P2SEL  |= P2SEL_INIT;                //Select port or module -function on port2
    P2DIR  &= P2DIR_INIT;                //Init port direction register of port2

    delay(65535);                       //Wait for watch crystal startup
    delay(65535);
    fllInit();                          //Init FLL to desired frequency using the 32k768 cystal as reference.
    
    TACTL  = TACTL_AFTER_FLL;           //setup timer (still stopped)
    CCTL0  = CCIE|CAP|CM_2|CCIS_1|SCS;  //select P2.2 with UART signal
    CCTL1  = 0;                         //
    CCTL2  = 0;                         //
    TACTL |= MC1;                       //start timer
    
    eint();                             //enable interrupts

}// SWUART_INIT
